import java.awt.Panel;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.BorderLayout; 
import java.awt.FlowLayout;
import types.DataClass;


class WheelInfoPanel extends Panel {
    DataClass   m_Data;
    FontLabel   m_lbLabel;
    FontLabel   m_ubLabel;
    WheelPanel  m_Wheel;
    public WheelInfoPanel(DataClass data) {
        m_Data = data;
        setLayout(new BorderLayout());
        m_lbLabel = new FontLabel("LB","Helvetica",Font.PLAIN,12,50,20);
        //m_ubLabel = new FontLabel("UB","Helvetica",Font.PLAIN,12,50,20);
        m_Wheel = new WheelPanel(data,90,90);
        add("North",m_lbLabel);
        //add("South",m_ubLabel);
        add("Center",m_Wheel);

    }
    public void myUpdate(DataClass data) {
        m_Data = data;
		m_lbLabel.setText("LB:"+Integer.toString(m_Data.lowerBound())+" UB:"+Integer.toString(m_Data.upperBound()));
        m_Wheel.myUpdate(data);
    }
	public void update(Graphics g) {
        paint(g);
    }
    public void paint(Graphics g) {
  		Rectangle frame=bounds();
		g.drawRect(0,0,frame.width-1,frame.height-1);
    }
}
